Dear All,

Please find below a few points we discussed today.
(apologies in advance if this is biased towards my point of view....)

Present: 
  - SCI: Paolo, Jerome
  - CS: Emmanuel, Ricardo 

Discussion about interfacing NoMad with live data treatment (Lamp, Mantid, etc...)

It was decided:
  - Ricardo will develop a http server (REST architecture) which will accept HTTP requests from NoMad.
  - Requests will always start from Nomad. CS software won't have the capability of querying NoMad.
  - Instead of sending a dictionary, Nomad will send a temporary NeXus file (a temporary file is already created for every instrument).
  - Once Nomad sends some info, the CS server can call / interact with data treatment software (Lamp, Mantid, etc...)
  - To be defined within the CS the interaction between the server and the data treatment software.
  - Nomad requests can be perform with an interval of e.g. 60 seconds. This interval can be extended, if for example, CS software is doing some heavy processing, with a response to a NoMad request with a certain waiting time estimate (e.g. ```{"status":"processing", "wait_estimate": 360 }```).
  - Messages should be in json format. Format to be defined. 
  - SCI will use the Unix system tool "curl" for the http requests.
  - SCI can use curl connect-timeout and max-time options for preventing NoMad to hang for long time.
  - Both Nexus files and json requests should be passed by HTTP POST.
  - NoMad can send json requests of the form ```{ "$toto"  : "cell" }```, in reply CS software sends the same NoMad variable with the requested operation (in this case the unit cell of a crystal). The response to the previous request could be similar to: ```{ "$toto"  : [10,10,10,90,90,90] }```.
  - The requests used in these json messages have still to be defined.
  - Given the heterogeneity of the nomenclature of nexus variables, it is foreseen to create a central repository (e.g. a table in the new database) with a predefined key (to be agreed between CS and SCI (and scientists?) ) and the corresponding nexus entry / name for every instrument.

The development will follow an "agile" methodology with continuous improvement and feed back from both working groups. A prototype for testing (receiving and acknowledge nexus files, status, parse nexus and json) should be ready soon. New functionalities will build up with time.

The first prototype and the respective curl commands for testing will be sent around on Monday.

Bonne soirée!

